unit DFilterMain;
(*
   ========================================================================
    " " DFiltr.
       .
   ========================================================================
         .
         
          
        24bit - .
   ========================================================================
    
   ()  ,    , , .
   ========================================================================
       
   ()   , ,  
   ========================================================================
*)

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ExtCtrls, Buttons, ComCtrls, Menus, ImgList,
  ToolWin,
  //     
  EngineImgService01, MainData, SGridEdit01,
  //   " "
  DFilterMainData01, DFilterService01, DFilterPopular,
  //   "MICROBASE"
  MbMain;

//========================================================================
//     
//========================================================================
type
  TFormDFilter = class(TForm)
    PanelDFilter1: TPanel;
    MainMenu1: TMainMenu;
    MMFiles: TMenuItem;
    MMFilters: TMenuItem;
    MMPopFilterH: TMenuItem;
    MMOperation: TMenuItem;
    MMPopFilterL: TMenuItem;
    MMRunFrag: TMenuItem;
    MMRunDest: TMenuItem;
    MMHelp: TMenuItem;
    MMExit: TMenuItem;
    MMPopFilterH1: TMenuItem;
    MMPopFilterH2: TMenuItem;
    MMPopFilterH3: TMenuItem;
    MMPopFilterL1: TMenuItem;
    MMPopFilterL2: TMenuItem;
    MMPopFilterL3: TMenuItem;
    PanelFragImages: TPanel;
    ScrollBox1: TScrollBox;
    ImgTestSource: TImage;
    ScrollBox2: TScrollBox;
    ImgTestTarget: TImage;
    Splitter1: TSplitter;
    ProgressBar1: TProgressBar;
    PanelDFilter2: TPanel;
    SGridFilter: TStringGrid;
    Label11: TLabel;
    EdFScale: TEdit;
    ImageList1: TImageList;
    MMGoToDB: TMenuItem;
    TrackBarLight: TTrackBar;
    TrackBarContrast: TTrackBar;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    SpBttAuto: TSpeedButton;
    SpBttNotAuto: TSpeedButton;
    Label2: TLabel;
    ToolBar1: TToolBar;
    TB1Sep1: TToolButton;
    TB1RunDB: TToolButton;
    TB1Sep2: TToolButton;
    TB1FPlus: TToolButton;
    TB1FMinus: TToolButton;
    TB1RunFrag: TToolButton;
    TB1Sep4: TToolButton;
    TB1RunDest: TToolButton;
    TB1Sep3: TToolButton;
    StTxtMessage: TStaticText;
    // -----------------------------------
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMExitClick(Sender: TObject);
    procedure MMGoToDBClick(Sender: TObject);
    procedure MMPopFilterH1Click(Sender: TObject);
    procedure MMPopFilterH2Click(Sender: TObject);
    procedure MMPopFilterH3Click(Sender: TObject);
    procedure MMPopFilterL1Click(Sender: TObject);
    procedure MMPopFilterL2Click(Sender: TObject);
    procedure MMPopFilterL3Click(Sender: TObject);
    procedure TB1FMinusClick(Sender: TObject);
    procedure TB1FPlusClick(Sender: TObject);
    procedure TB1RunDBClick(Sender: TObject);
    procedure TB1RunFragClick(Sender: TObject);
    procedure TB1RunDestClick(Sender: TObject);
    procedure SpBttAutoClick(Sender: TObject);
    procedure SpBttNotAutoClick(Sender: TObject);
    // -----------------------------------
    //    
    procedure EdFScaleChange(Sender: TObject);
    procedure TrackBarLightChange(Sender: TObject);
    procedure TrackBarContrastChange(Sender: TObject);
    //
    procedure SGEdClick(Sender: TObject);
    procedure SGEdKeyDown(Sender: TObject; var Key: Word;
                          Shift: TShiftState);
    procedure SGEdExit(Sender: TObject);
    procedure MMRunDestClick(Sender: TObject);
    procedure MMRunFragClick(Sender: TObject);
    procedure MMHelpClick(Sender: TObject);

    // -----------------------------------
  private
    //         
    function SGEditDFOneCell(Sender: TObject) : boolean;
    //      
    procedure UnDoEdMarker(RqEd : boolean);
    //      TrackBarLight
    procedure CalcNewDFScale();
    //        TrackBarContrast
    procedure NewFocusFilter();
    //        
    procedure LoadDFilterFromArr(RqArrFilter : TDFiltrArray);
    //   MicroBase
    procedure RunDB();
    //       
    procedure ResetDFAccsess();
    //     
    procedure RunFilterForTestFragent();
    //     .    
    procedure RunFilterForSrcImg();
  public
    { Public declarations }
  end;

var FormDFilter : TFormDFilter;

implementation
{$R *.dfm}

//     
var  SGEdCB : TSGEdCB;

//     .
//   LoadDFilterFromArr
//
var LoadFFocus  : integer;  //    
    LoadFScale  : integer;  //    

// ========================================================================
//    
// ========================================================================
// 23.02.2013
//  
procedure TFormDFilter.FormCreate(Sender: TObject);
begin
   //       100
   SetCopyDFiltrArray(DFiltrArray, DFiltrScale, 100);
   // ------------------------
   //      
   FillChar(SGEdCB, SizeOf(SGEdCB), #0);
   // ------------------------
   //  StringGrid Editor (unit SGridEdit01)
   SGridFilter.OnClick := nil;
   //    StringGrid Editor
   InitSGridEd(SGridFilter, DFilterMaxLen);
   //    SGrid
   ShowDFiltrArray (SGridFilter, DFiltrArray);
   //     StringGrid
   SGridFilter.OnClick   := SGEdClick;
   SGridFilter.OnKeyDown := SGEdKeyDown;
   SGridFilter.OnExit    := SGEdExit;
   // ------------------------
   //   
   ShowDFiltrScale(EdFScale,  DFiltrScale);
   //      
   SpBttAutoClick(nil);
end;
//-------------------------------------------------------------------------
// 23.02.2013
//    
procedure TFormDFilter.MMExitClick(Sender: TObject);
begin
   Close;
end;

// ========================================================================
//    
// ========================================================================
//-------------------------------------------------------------------------
// StringGrid -    
//-------------------------------------------------------------------------
// 22.02.2013
//         
function TFormDFilter.SGEditDFOneCell(Sender: TObject) : boolean;
begin
   Result := False;
   with SGEdCB do
   begin
     //   StringGrid      
     NTxt := SGridFilter.Cells[SCol, SRow];
     //        
     SInt := DFiltrArray[SRow, SCol];
     SScl := DFiltrScale;
     //      
     if SGCellToInt(Sender, SCol, SRow, NTxt, NInt, ECode)
     then begin
        //        
        //        
        if NInt <> SInt
        then begin
           //      
           DFiltrArray[SRow, SCol] := NInt;
           //      
           NScl := CalcDFScale(DFiltrArray);
           if NScl > 0  //   
           then begin
              //    
              DFiltrScale := NScl;
              //  
              ShowDFiltrScale(EdFScale,  DFiltrScale);
              //     
              LoadFFocus := DFiltrArray[DFilterFocusRC, DFilterFocusRC];
              LoadFScale := DFiltrScale;
              //     
              SRow := NRow;
              SCol := NCol;
              //   
              fRE    := False;  //    
              Result := True;   //  
           end
           else begin
              //    
              MessageDlg('    .'
                       + #13#10
                       + '   .',
                        mtWarning, [mbOk], 0);
              //      
              DFiltrArray[SRow, SCol] := SInt;
              //      StringGrid
              if SInt <> 0
              then SGridFilter.Cells[SCol, SRow] := IntToStr(SInt)
              else SGridFilter.Cells[SCol, SRow] := '';
              //      
              fRE := True;
           end;
        end
        else begin
           //       
           fRE    := False;    //    
           Result := True;     //  
        end;
     end
     else begin
        //      
        DFiltrArray[SRow, SCol] := SInt;
        //      StringGrid
        if SInt <> 0
        then SGridFilter.Cells[SCol, SRow] := IntToStr(SInt)
        else SGridFilter.Cells[SCol, SRow] := '';
        //      
        fRE    := True;
     end;
   end;
end;
//-------------------------------------------------------------------------
// 22.02.2013
//      
procedure TFormDFilter.UnDoEdMarker(RqEd : boolean);
begin
  with SGEdCB do
  begin
     SGridFilter.Row := SRow;
     SGridFilter.Col := SCol;
     NRow := SRow;
     NCol := SCol;
     fMv := False;     //    
     if RqEd
     then begin
       //      
       SGridFilter.EditorMode := True;
       EdM := True;
     end;
  end;
end;
//-------------------------------------------------------------------------
// 22.02.2013
//     StringGrid    
//           
//        .
procedure TFormDFilter.SGEdClick(Sender: TObject);
begin
   //   StringGrid   Click
   SGridFilter.OnClick := nil;
   with SGEdCB do
   begin
      //      
      NRow := SGridFilter.Row;;
      NCol := SGridFilter.Col;
      //    
      if  (SRow <> NRow) or (SCol <> NCol)
      then fMv := True
      else fMv := False;
      //     
      if fMv
      then begin
         //      
         if not SGEditDFOneCell(Sender)
         then begin
             //      
             UnDoEdMarker(False);
         end;
      end;
      //        
      SRow := NRow;
      SCol := NCol;
      EdM  := SGridFilter.EditorMode;
   end;
   //   StringGrid   Click
   SGridFilter.OnClick := SGEdClick;
end;
//-------------------------------------------------------------------------
// 22.02.2013
//       ENTER ( )
procedure TFormDFilter.SGEdKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN
  then begin
     with SGEdCB do
     begin
       if not EdM
       then begin
          //       
          NRow := SGridFilter.Row;;
          NCol := SGridFilter.Col;
          SRow := NRow;
          SCol := NCol;
          EdM  := True;
       end
       else begin
        //      
        SGEditDFOneCell(Sender);
        EdM  := False;
       end;
     end;
  end;
end;

//-------------------------------------------------------------------------
// 22.02.2013
//       
procedure TFormDFilter.SGEdExit(Sender: TObject);
begin
  with SGEdCB do
  begin
     if SGridFilter.EditorMode
     then begin
        if not SGEditDFOneCell(Sender)
        then begin
           //      
           UnDoEdMarker(False);
        end;
     end;
  end;
end;

//-------------------------------------------------------------------------
//    
//-------------------------------------------------------------------------
// 21.02.2013
//    
procedure TFormDFilter.EdFScaleChange(Sender: TObject);
var  NewScale : integer;
begin
   if TextToInt (EdFScale.Text, NewScale)
   then begin
      if NewScale > 0
      then begin
         //  
         DFiltrScale := NewScale;
      end
      else begin
         MessageDlg('    .'
                   + #13#10
                   + '   .',
                   mtWarning, [mbOk], 0);
         //    
         ShowDFiltrScale(EdFScale, DFiltrScale);
      end;
   end
   else begin
       MessageDlg('    : ' + EdFScale.Text
                +   #13#10
                + '    .'
                +   #13#10
                + '    .',
               mtWarning, [mbOk], 0);
        //    
        ShowDFiltrScale(EdFScale, DFiltrScale);
   end;
end;
//-------------------------------------------------------------------------
// 20.02.2013
//       TrackBarLight
procedure TFormDFilter.CalcNewDFScale();
var IScale   : integer;
    MaxDelta : integer;
    NewScale : integer;
begin
   IScale := CalcDFScale(DFiltrArray);
   MaxDelta := Trunc(IScale * 45 / 100);  //  45%  
   if MaxDelta > 0
   then begin
       NewScale := IScale - Trunc( MaxDelta * TrackBarLight.Position / 10);
       DFiltrScale := NewScale;
       EdFScale.Text := IntToStr(DFiltrScale);
   end;
end;
//-------------------------------------------------------------------------
// 20.02.2013
//      TrackBarLight
procedure TFormDFilter.TrackBarLightChange(Sender: TObject);
begin
  CalcNewDFScale();
end;
//-------------------------------------------------------------------------
// 20.02.2013
//         TrackBarContrast
procedure TFormDFilter.NewFocusFilter();
var NewScale : integer;
    MaxDelta : integer;
    OldFocus : integer;
    NewFocus : integer;
begin
   if LoadFScale > 0
   then begin
      //    
      OldFocus := DFiltrArray[DFilterFocusRC, DFilterFocusRC];
      //    < 100%  
      MaxDelta := LoadFScale - 1;
      //   
      NewFocus := LoadFFocus - Trunc(MaxDelta * TrackBarContrast.Position / 10);
      DFiltrArray[DFilterFocusRC, DFilterFocusRC]:= NewFocus;
      //      
      NewScale := CalcDFScale(DFiltrArray);
      if NewScale > 0
      then begin
         //   
         DFiltrScale := NewScale;
      end
      else begin
         DFiltrScale := LoadFScale;
         DFiltrArray[DFilterFocusRC, DFilterFocusRC]:= OldFocus;
      end;
      //  
      EdFScale.Text := IntToStr(DFiltrScale);
      SGridFilter.Cells[DFilterFocusRC, DFilterFocusRC] := IntToStr
                       (DFiltrArray[DFilterFocusRC, DFilterFocusRC]);
      //   
      TrackBarLight.Enabled := False;
      TrackBarLight.Position := 0;
      TrackBarLight.Enabled := True;
   end;
end;
//-------------------------------------------------------------------------
// 20.02.2013
//        TrackBarContrast
procedure TFormDFilter.TrackBarContrastChange(Sender: TObject);
begin
  NewFocusFilter();
end;

// ========================================================================
//    . (.  unit DFilterPopular)
// ========================================================================
// 01.02.2012
//        
procedure TFormDFilter.LoadDFilterFromArr(RqArrFilter : TDFiltrArray);
var ARow, ACol : integer;
begin
   // ---------------------------------
   //  Grid
   SGridFilter.Enabled := False;
   //     
   with SGridFilter do
   begin
      for ARow := Low(RqArrFilter) to High(RqArrFilter) do
      begin
          for ACol := Low(RqArrFilter[ARow]) to High(RqArrFilter[ARow])
          do begin
            //    
            DFiltrArray[ARow, ACol] := RqArrFilter[ARow, ACol];
            //   
            if RqArrFilter[ARow, ACol] <> 0
            then Cells[ACol, ARow] := IntToStr(RqArrFilter[ARow, ACol])
            else Cells[ACol, ARow] := '';
          end;
      end;
   end;
   // ---------------------------------
   //       
   TrackBarLight.Enabled := False;
   TrackBarContrast.Enabled := False;
   EdFScale.Enabled := False;
   TrackBarLight.Position := 0;
   TrackBarContrast.Position := 0;
   // ---------------------------------
   //     
   LoadFFocus := DFiltrArray[DFilterFocusRC, DFilterFocusRC];
   //      
   LoadFScale := CalcDFScale(DFiltrArray);
   DFiltrScale := LoadFScale;
   EdFScale.Text := IntToStr(DFiltrScale);
   // ---------------------------------
   //        
   ResetDFAccsess();
end;

//-------------------------------------------------------------------------
// 21.02.2012
//       (ToolBar1)
procedure TFormDFilter.TB1FMinusClick(Sender: TObject);
begin LoadDFilterFromArr(FilterL1) end;
// 21.02.2012
//       (ToolBar1)
procedure TFormDFilter.TB1FPlusClick(Sender: TObject);
begin LoadDFilterFromArr(FilterH1) end;
//-------------------------------------------------------------------------
// 21.02.2012
//     ()
procedure TFormDFilter.MMPopFilterH1Click(Sender: TObject);
begin LoadDFilterFromArr(FilterH1) end;
// 21.02.2012
//     ()
procedure TFormDFilter.MMPopFilterH2Click(Sender: TObject);
begin LoadDFilterFromArr(FilterH2) end;
// 21.02.2012
//     ()
procedure TFormDFilter.MMPopFilterH3Click(Sender: TObject);
begin LoadDFilterFromArr(FilterH3) end;
//-------------------------------------------------------------------------
// 21.02.2012
//     ()
procedure TFormDFilter.MMPopFilterL1Click(Sender: TObject);
begin LoadDFilterFromArr(FilterL1) end;
// 21.02.2012
//     ()
procedure TFormDFilter.MMPopFilterL2Click(Sender: TObject);
begin LoadDFilterFromArr(FilterL2) end;
// 21.02.2012
//     ()
procedure TFormDFilter.MMPopFilterL3Click(Sender: TObject);
begin LoadDFilterFromArr(FilterL3) end;

// ========================================================================
//     
// ========================================================================
//       
procedure TFormDFilter.ResetDFAccsess();
begin
 if SpBttAuto.Down
 then begin
    //    
    SGridFilter.Enabled := False;
    EdFScale.Enabled := False;
    TrackBarLight.Enabled := True;
    TrackBarContrast.Enabled := True;
    //      
    TB1RunDest.Enabled := True;
    MMRunDest.Enabled := True;
    StTxtMessage.Caption := ' ';
 end else begin
    //    
    SGridFilter.Enabled := True;
    EdFScale.Enabled := True;
    TrackBarLight.Enabled := False;
    TrackBarContrast.Enabled := False;
    //      
    TB1RunDest.Enabled := False;
    MMRunDest.Enabled := False;
    StTxtMessage.Caption := '  ';
 end;
end;
//-------------------------------------------------------------------------
//  
procedure TFormDFilter.SpBttAutoClick(Sender: TObject);
begin
 ResetDFAccsess();
end;

//-------------------------------------------------------------------------
//     
procedure TFormDFilter.SpBttNotAutoClick(Sender: TObject);
begin
 ResetDFAccsess();
end;

// ========================================================================
//    . (unit MbMain)
// ========================================================================
// 21.02.2012
//   MicroBase
procedure TFormDFilter.RunDB();
begin
  MbSetFilter := False;
  MbMain.FormMicroBase.ShowModal;
  //   MicroBase
  if MbSetFilter
  then begin
    // MicroBase    MbSetFilter = True
    //     s   
    LoadDFilterFromArr(DFiltrArray);
    MbSetFilter := False;
  end;
end;
// 21.02.2012
//   MicroBase (ToolBar1)
procedure TFormDFilter.TB1RunDBClick(Sender: TObject);
begin RunDB(); end;
// 21.02.2012
//   MicroBase ( )
procedure TFormDFilter.MMGoToDBClick(Sender: TObject);
begin RunDB(); end;

// ========================================================================
//     . (unit DigitFilter01)
// ========================================================================
// 23.02.2012
//     
procedure TFormDFilter.RunFilterForTestFragent();
begin
 //  
 if DFiltrScale > 0
 then begin
    //  BGR-   Color-
    TabBRGtoTabColor (Addr(ArrFragSrcBGR),Addr(ImgTabColorSrc));

    //    Color-
    DFilterAplly (DFiltrArray,
                  DFiltrScale,
                  Addr(ImgTabColorSrc),
                  Addr(ImgTabColorTrg),
                  ProgressBar1);

    //   Src- 
    SetLength(ImgTabColorSrc,0);
    //  Color-   BGR-
    TabColorToTabBRG (Addr(ImgTabColorTrg), Addr(ArrFragTrgBGR));
    //   Target- 
    SetLength(ImgTabColorTrg,0);
    //     Image 
    ImgTabToImage(Addr(ArrFragTrgBGR),
                       ImgTestTarget,
                       ProgressBar1);
  end
  else MessageDlg('    .'
                + #13#10
                + '   .',
                  mtWarning, [mbOk], 0);
end;
//-------------------------------------------------------------------------
// 23.02.2012
//     
procedure TFormDFilter.TB1RunFragClick(Sender: TObject);
begin
   RunFilterForTestFragent();
end;
// 23.02.2012
procedure TFormDFilter.MMRunFragClick(Sender: TObject);
begin
//
end;

// ========================================================================
// 23.02.2012
//     .    
procedure TFormDFilter.RunFilterForSrcImg();
begin
 //  
 if DFiltrScale > 0
 then begin
     //    
     Screen.Cursor := crHourGlass;
     try
       //  BGR-    Color-
       TabBRGtoTabColor (Addr(SrcImgTabBGR),Addr(ImgTabColorSrc));

       //    Color-
       DFilterAplly (DFiltrArray,
                     DFiltrScale,           
                     Addr(ImgTabColorSrc),
                     Addr(ImgTabColorTrg),
                     ProgressBar1);

       //   Src- 
       SetLength(ImgTabColorSrc,0);
       //  Color-   BGR-
       TabColorToTabBRG (Addr(ImgTabColorTrg), Addr(TrgImgTabBGR));
       //   Target- 
       SetLength(ImgTabColorTrg,0);
       //     Image  
       ImgTabToImage(Addr(TrgImgTabBGR),  // BGR-  
                     pImageTarget,   // Image  
                     ProgressBar1);
       //    
       pPageControlMain.TabIndex := 1;
    finally
       //     
       Screen.Cursor := crDefault;
       //    
       Close;
    end;
 end
 else MessageDlg('    .'
                + #13#10
                + '   .',
                  mtWarning, [mbOk], 0);
end;

//-------------------------------------------------------------------------
// 30.01.2012
//     .    
procedure TFormDFilter.TB1RunDestClick(Sender: TObject);
begin
  RunFilterForSrcImg();
  //    MainData
  flgFiltrApply := True;  //    
end;
// 30.01.2012
procedure TFormDFilter.MMRunDestClick(Sender: TObject);
begin
  RunFilterForSrcImg();
end;

// ========================================================================
// HELP ;)
// ========================================================================
procedure TFormDFilter.MMHelpClick(Sender: TObject);
begin
  MessageDlg
    ('       :'
    + #13#10
    + '1. ., ..   . .:'
    + #13#10
    + '    "", 2005.-1072. ISBN 5-94836-028-8'
    + #13#10
    + '2. ..     .'
    + #13#10
    + '    .: . , 1979.-312c., .',
    mtInformation, [mbOk], 0);
end;

// ========================================================================
//      
// (  )
// ========================================================================
// 06.02.2013
procedure TFormDFilter.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
//  Src- 
   MimimizeBitMap (ImgTestSource.Picture.Bitmap);   //  BitMap
   SetLength(ArrFragSrcBGR,0);
   SetLength(ImgTabColorSrc,0);
//  Target- 
   MimimizeBitMap (ImgTestTarget.Picture.Bitmap);   //  BitMap
   SetLength(ArrFragTrgBGR, 0);
   SetLength(ImgTabColorTrg,0);
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================

end.
